/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class GraphicHelper
extends Dialog
implements ActionListener,
MouseListener,
MouseMotionListener {
    private Point origin;
    private Button cancelButton;
    private TextArea msgs;
    private BrowserApplet browser;
    private GraphicPanel grPanel;
    private Point p0;
    private Point p1;
    private Point c0;
    private Component grComp;
    private Component clicked;
    private Component grTop;
    private int lineCounter;
    private static String CancelCommand = "Cancel";

    public GraphicHelper(BrowserApplet browserApplet, GraphicPanel graphicPanel) {
        super(browserApplet.getFrame(), "Graphic Helper", false);
        this.browser = browserApplet;
        this.grPanel = graphicPanel;
        ((Component)this).setSize(300, 300);
        this.setLayout(new BorderLayout());
        this.msgs = new TextArea();
        this.msgs.setEditable(false);
        this.add("Center", this.msgs);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand(CancelCommand);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        panel.add(this.cancelButton);
        this.add("South", panel);
        this.grTop = this.grPanel.getGraphicComponent();
        this.registerListeners(this.grTop);
        this.grComp = this.grPanel.getGraphicComponent();
        this.addWindowListener(new CloseWindowHandler());
    }

    public void registerListeners(Component component) {
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.registerListeners(componentArray[n]);
                ++n;
            }
            return;
        }
        component.addMouseMotionListener(this);
        component.addMouseListener(this);
    }

    public void deregisterListeners(Component component) {
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.deregisterListeners(componentArray[n]);
                ++n;
            }
            return;
        }
        component.removeMouseMotionListener(this);
        component.removeMouseListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CancelCommand)) {
            this.close();
            return;
        }
        System.out.println("BrowserApplet doesn't understand event:" + actionEvent);
    }

    public void close() {
        this.browser.graphicHelperEnded();
        this.deregisterListeners(this.grTop);
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        System.out.println("Clicked " + mouseEvent.getClickCount() + " times at abs(" + mouseEvent.getPoint().x + "," + mouseEvent.getPoint().y + ")");
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.p0 = mouseEvent.getPoint();
        this.clicked = mouseEvent.getComponent();
        if (this.clicked != null) {
            this.c0 = this.clicked.getLocation();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.finishedDragging();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.finishedDragging();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.clicked != null) {
            this.p1 = mouseEvent.getPoint();
            int n = this.p1.x - this.p0.x;
            int n2 = this.p1.y - this.p0.y;
            this.c0.x += n;
            this.c0.y += n2;
            this.clicked.setLocation(this.c0);
            this.grTop.repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private void finishedDragging() {
        if (this.clicked != null) {
            ++this.lineCounter;
            this.msgs.append(String.valueOf(this.lineCounter) + ". Dragged to rel(" + this.c0.x + "," + this.c0.y + ")\n");
            this.clicked = null;
        }
    }

    private class CloseWindowHandler
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            GraphicHelper.this.close();
        }

        CloseWindowHandler() {
            GraphicHelper.this = GraphicHelper.this;
        }
    }
}

